package gov.va.med.mhv.bluebutton.model;

import java.io.Serializable;
import java.sql.Clob;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;


@Entity
@Table(name = "MHV_DOWNLOAD_DATA")
public class MhvDownloadData implements Serializable{

	private static final long serialVersionUID = 1023582775856070276L;

	@Id
	@Column(name = "MHV_DOWNLOAD_DATA_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long		downloadDataId;
	
	@Column(name = "MHV_DOWNLOAD_REPORT_ID")
	private Long		downloadReportId;
	
	@Version 
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "CREATED_DATE")
	private Timestamp		createdTime;

	
	@Column(name = "MODIFIED_DATE")
	private Timestamp		modifiedTime;
	
	@Column(name = "FILE_TYPE")
	private String		fileType;
	

	@Column(name = "FILE_CONTENTS")
	private Clob	fileContents;


	public Long getDownloadDataId() {
		return downloadDataId;
	}


	public void setDownloadDataId(Long downloadDataId) {
		this.downloadDataId = downloadDataId;
	}


	public Long getDownloadReportId() {
		return downloadReportId;
	}


	public void setDownloadReportId(Long downloadReportId) {
		this.downloadReportId = downloadReportId;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public Timestamp getCreatedTime() {
		return createdTime;
	}


	public void setCreatedTime(Timestamp createdTime) {
		this.createdTime = createdTime;
	}


	public Timestamp getModifiedTime() {
		return modifiedTime;
	}


	public void setModifiedTime(Timestamp modifiedTime) {
		this.modifiedTime = modifiedTime;
	}


	public String getFileType() {
		return fileType;
	}


	public void setFileType(String fileType) {
		this.fileType = fileType;
	}


	public Clob getFileContents() {
		return fileContents;
	}


	public void setFileContents(Clob fileContents) {
		this.fileContents = fileContents;
	}	
	
	
	
}
